;;; Project : esdffm
;;; Version : 1.0
;;; File : fr_sd_tts.scm
;;; Author : P.L. Nageoire
;;; Date : Sat Jan 21 11:17:21 2006
;;; Licence : GPL
; ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; This code is directly inspired from the text2wave script
;;; of the festival distribution see 
;;; http://www.festvox.org/festival/index.html
;;; However it attempts to use festival freebsoft utils see
;;; http://www.freebsoft.org/festival-freebsoft-utils/
;;; in order to provide language, voice, punctuation etc
;;; selection.

(require 'speech-dispatcher)

;;;  --- Global variables  ---

(defvar fr_sd_tts_voice nil)
(defvar fr_sd_tts_rate 0)
(defvar fr_sd_tts_language "en")
(defvar fr_sd_tts_punctuation 'none)
(defvar fr_sd_tts_output nil)
(defvar fr_sd_tts_output_type 'wav)
(defvar fr_sd_tts_output_frequency nil)
(defvar fr_sd_tts_files '("-"))

;;;  --- End Global variables  ---

(define (fr_sd_tts_help)
  (format t "fr_sd_tts [options] textfile\n")
  (format t "Convert a text file into speech. Play or save the result\n.")
  (format t "Options :\n")
  (format t "-v Sets voice.\n")
  (format t "-r RATE Sets speech rate. Value should range between -100 and +100.\n")
  (format t "-o FILE Specify where output should go. If not specified,\n")
  (format t "\tresult is played according to festival playing mechanism.\n")
  (format t "-otype TYPE Specifies output type (default is wav.)\n")
  (format t "-m MODE Sets punctuation mode possible values are\n")
  (format t "\tnone some all.\n")
  (format t "-l LANGUAGE Sets speech language. Possible values are fr or en.\n")
  (format t "-F FREQ Sets output frequency.\n")
  (quit))

(define (fr_sd_tts_get_options)
  (or (and
       (or (member_string "-h" arguments)
	   (member_string "-help" arguments)
	   (member_string "--help" arguments)
	   (member_string "-?" arguments))
       (fr_sd_tts_help)
       nil)
      (let ((options arguments)
	    (files))
	(while options
	       (begin
		 (cond
		  ((string-equal "-v" (car options))
		   (set! fr_sd_tts_voice (car (cdr options)))
		   (set! options (cdr options)))
		  ((string-equal "-r" (car options))
		   (set! fr_sd_tts_rate (read-from-string
					 (car (cdr options))))
		   (set! options (cdr options)))
		  ((string-equal "-o" (car options))
		   (set! fr_sd_tts_output (car (cdr options)))
		   (set! options (cdr options)))
		  ((string-equal "-m" (car options))
		   (set! fr_sd_tts_punctuation (car (cdr options)))
		   (set! options (cdr options)))
		  ((string-equal "-l" (car options))
		   (set! fr_sd_tts_language (car (cdr options)))
		   (set! options (cdr options)))
		  ((string-equal "-F" (car options))
		   (set! fr_sd_tts_output_frequency
			 (parse-number
			  (car (cdr options))))
		   (set! options (cdr options)))
		  (t (set! files (cons (car options) files))))
		 (set! options (cdr options))))
	(if files
	    (set! fr_sd_tts_files (reverse files)))
	t)))

(define (fr_sd_tts_main)
  (and (fr_sd_tts_get_options)
       (begin
	 (speechd-set-rate fr_sd_tts_rate)
	 (speechd-set-language fr_sd_tts_language)
	 (speechd-set-voice fr_sd_tts_voice)
	 (speechd-set-punctuation-mode fr_sd_tts_punctuation)
	 (let ((wave
		(wave-concat
		 (mapcar
		  (lambda (file)
		    (let ((utt (speechd-speak*
				(read-file file))))
		      (if fr_sd_tts_output_frequency
			  (utt.wave.resample
			   utt
			   fr_sd_tts_output_frequency))
		      (utt.wave utt)))
		  fr_sd_tts_files))))
	   (if fr_sd_tts_output
	       (wave.save wave fr_sd_tts_output
			  fr_sd_tts_output_type)
	       (wave.play wave))))))

(fr_sd_tts_main)
(provide 'fr_sd_tts)